/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour.plants;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.messaging.types.TreeFallenMessage;

public class FallingTreeBehaviour
implements BehaviourComponent {
    private MessageDispatcher messageDispatcher;
    private Entity parentEntity;
    private final boolean fallToWest;
    private float absoluteRotationAmount = 0.0f;
    private static final float ROTATION_DEGREES_PER_SECOND = 120.0f;

    public FallingTreeBehaviour(boolean fallToWest) {
        this.fallToWest = fallToWest;
    }

    @Override
    public FallingTreeBehaviour clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        FallingTreeBehaviour cloned = new FallingTreeBehaviour(this.fallToWest);
        cloned.init(this.parentEntity, messageDispatcher, tiledMap);
        return cloned;
    }

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.messageDispatcher = messageDispatcher;
        this.parentEntity = parentEntity;
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
        PlantEntityAttributes attributes = (PlantEntityAttributes)this.parentEntity.getPhysicalEntityComponent().getAttributes();
        attributes.setLeafColorChangeAmount(-1.0f);
        float rotationChange = 0.05f + 0.9f * (this.absoluteRotationAmount / 90.0f);
        float extraRotation = deltaTime * rotationChange * 120.0f;
        this.absoluteRotationAmount += extraRotation;
        if (this.fallToWest) {
            this.parentEntity.getLocationComponent().setRotation(this.absoluteRotationAmount);
        } else {
            this.parentEntity.getLocationComponent().setRotation(-this.absoluteRotationAmount);
        }
        if (this.absoluteRotationAmount > 85.0f) {
            this.messageDispatcher.dispatchMessage(322, new EntityMessage(this.parentEntity.getId()));
            this.messageDispatcher.dispatchMessage(323, new TreeFallenMessage(this.parentEntity.getLocationComponent().getWorldPosition(), attributes.getActualBranchColor(), attributes.getSpecies(), attributes.getCurrentTileHeight(), this.fallToWest));
        }
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return null;
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return true;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return false;
    }

    @Override
    public boolean isJobAssignable() {
        return false;
    }
}

